%option noyywrap

%x PRE
%x NOWIKI

%{

#include <string.h>
#include "main.h"
#include "site.h"
#include "wiki.h"

char *passTags[] = {
	"b",
	"/b",
	"i",
	"/i",
	"tt",
	"/tt",
	NULL
};

Boolean IsWikiWord(char *word)
{
	int i = 0;
	int j = 0;
	char *p = word;
	while(*p)
	{
		if(isupper(*p))
			i++;
		if(islower(*p))
			j++;
		if(i > 1 && j > 0)
			return(true);
		p++;
	}
	return(false);
}

#define IN_TERM		0x00000001

int inHeading = 0;
int bulletLevel = 0;
int listLevel = 0;
int defLevel = 0;
unsigned long format = 0;
int linkNumber = 0;
int inPreBlock = 0;

void LineCleanup()
{
	if(inHeading)
	{
		printf("</h%d>", inHeading);
		inHeading = 0;
	}
}

void ListCleanup()
{
	int i;

	if(inPreBlock)
	{
		printf("</pre>\n");
		inPreBlock = 0;
	}

	for(i = 0; i < bulletLevel; i++)
		printf("</ul>\n");
	bulletLevel = 0;

	for(i = 0; i < listLevel; i++)
		printf("</ol>\n");
	listLevel = 0;

	for(i = 0; i < defLevel; i++)
		printf("</dl>\n");
	defLevel = 0;
}

%}

%%
^[^ \n*#;]	{
	ListCleanup();
	REJECT; /* let the other line rules get a chance */
		}
^" "+		{
	if(inPreBlock == 0)
	{
		printf("<pre>\n");
		inPreBlock = 1;
	}
	ECHO;
		}
<INITIAL>\<[nN][oO][wW][iI][kK][iI]\> {
	BEGIN NOWIKI;
	printf("<!-- nowiki -->\n");
	}
<NOWIKI>\<\/[nN][oO][wW][iI][kK][iI]\> {
	BEGIN INITIAL;
	printf("<!-- end nowiki -->\n");
	}
<PRE,INITIAL>\<[^> \r\n]+\>	{
	char *str = strdup(yytext);
	char *p = str, *s;
	int i = 0;
	Boolean done = false;
	p++;
	str[strlen(str) - 1] = '\0';
	s = p;
	while(*s)
	{
		*s = tolower(*s);
		s++;
	}

	while(passTags[i])
	{
		if(!strcmp(p, passTags[i]))
		{
			printf("<%s>", p);
			done = true;
			break;
		}
		i++;
	}
	if(!done)
	{
		if(!strcmp(p, "pre"))
		{
			printf("<pre>");
			BEGIN PRE;
		}
		else if(!strcmp(p, "/pre"))
		{
			printf("</pre>");
			BEGIN INITIAL;
		}
	}

	free(str);
		}
\"\"		;
http:\/\/[^ \r\n]*	{
	printf("<a href=\"%s\">%s</a>", yytext, yytext);
		}
ftp:\/\/[^ \r\n]*	{
	printf("<a href=\"%s\">%s</a>", yytext, yytext);
		}
mailto:\/\/[^ \r\n]*	{
	printf("<a href=\"%s\">%s</a>", yytext, yytext);
		}
\[[^\]\r\n]+\]	{
	char *l = strdup(yytext);
	char *link = l;
	char *p;
	link++;
	p = strchr(link, ']');
	if(p)
		*p = '\0';
	p = strchr(link, ' ');
	if(p)
	{
		*(p++) = '\0';
		printf("<a href=\"%s\">%s</a>", link, p);
	} else {
		linkNumber++;
		printf("<a href=\"%s\">[%d]</a>", link, linkNumber);
	}
	free(l);
		}
<INITIAL,PRE,NOWIKI>&[^;\r\n]+;	printf("%s", yytext);
<INITIAL,PRE,NOWIKI>\<		printf("&lt;");
<INITIAL,PRE,NOWIKI>\>		printf("&gt;");
<INITIAL,PRE,NOWIKI>&		printf("&amp;");
<INITIAL>^!+		{
		inHeading = yyleng;
		if(inHeading > 6)
			inHeading = 6;
		printf("<h%d>", inHeading);
		}
<INITIAL>----		printf("<hr>");
<INITIAL>[A-Za-z]+	{
	if(IsWikiWord(yytext))
	{
		if(IsWikiDefined(yytext))
			printf("<a href=\"%s\">%s</a>", yytext, yytext);
		else
			printf("<u>%s</u><a href=\"%s/%s\">?</a>", yytext, WikiEditPath(), yytext);
	}
	else
		ECHO;
		}
<INITIAL>^\*+		{
	int i;
	if(yyleng == bulletLevel)
		printf("<li>");
	else if(yyleng > bulletLevel)
	{
		for(i = bulletLevel; i < yyleng; i++)
			printf("<ul>\n");
		bulletLevel = yyleng;
		printf("<li>");
	}
	else
	{
		for(i = yyleng; i < bulletLevel; i++)
			printf("</ul>\n");
		bulletLevel = yyleng;
		printf("<li>");
	}
		}
<INITIAL>^\#+		{
	int i;
	if(yyleng == listLevel)
		printf("<li>");
	else if(yyleng > listLevel)
	{
		for(i = listLevel; i < yyleng; i++)
			printf("<ol>\n");
		listLevel = yyleng;
		printf("<li>");
	}
	else
	{
		for(i = yyleng; i < listLevel; i++)
			printf("</ol>\n");
		listLevel = yyleng;
		printf("<li>");
	}
		}
<INITIAL>^\;+		{
	int i;
	format |= IN_TERM;
	if(yyleng == defLevel)
		printf("<dt>");
	else if(yyleng > defLevel)
	{
		for(i = defLevel; i < yyleng; i++)
			printf("<dl>\n");
		defLevel = yyleng;
		printf("<dt>");
	}
	else
	{
		for(i = yyleng; i < defLevel; i++)
			printf("</dl>\n");
		defLevel = yyleng;
		printf("<dt>");
	}
		}
<INITIAL>^\:+		{
	printf("<spacer type=horizontal size=%d>", yyleng * INDENT_PIXELS);
		}
:		{
	/* definition after ; */
	if(format & IN_TERM)
	{
		format &= ~IN_TERM;
		printf("<dd>");
	}
	else
		ECHO;
		}
^\n		{
	ListCleanup();
	LineCleanup();
	printf("<p>\n");
		}
\n		{
	/* end of line clean up */
	LineCleanup();
	ECHO;
		}
<<EOF>>		{
	if(inPreBlock)
	{
		printf("</pre>\n");
		inPreBlock = 0;
	}
	yyterminate();
		}
<PRE,INITIAL>.	ECHO;

%%

