#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include "main.h"
#include "site.h"
#include "cgi.h"
#include "wiki.h"

extern FILE *yyin;

char *WikiEditPath()
{
	static char buf[256];
	char *p = CGIReadScript();
	if(!p)
		return(NULL);
	strcpy(buf, p);
	p = strrchr(buf, '/');
	if(p)
		*p = '\0';
	strcat(buf, EDIT_PAGE);
	return(buf);
}

char *WikiSearchPath()
{
	static char buf[256];
	char *p = CGIReadScript();
	if(!p)
		return(NULL);
	strcpy(buf, p);
	p = strrchr(buf, '/');
	if(p)
		*p = '\0';
	strcat(buf, SEARCH_PAGE);

	return(buf);
}

Boolean IsWikiDefined(char *topic)
{
	char w[256], path[256];
	char *p = CGIReadPath();
	struct stat statbuf;

	sprintf(path, "%s/%s", WIKI_PATH, topic);

	if(stat(path, &statbuf) == 0)
		return(true);

	return(false);
}

Boolean CheckName(char *name)
{
	char *p = name;
	if(*name == '.')
		return(false);
	if(*name == '\0')
		return(false);
	if(strchr(name, '/'))
		return(false);

	while(*p)
	{
		if(isdigit(*p))
			return(false);
		if(!isalpha(*p))
			return(false);
		p++;
	}
	return(true);
}

void Wiki(char *name)
{
	char path[256];
	char topic[256];
	FILE *f;
	char buf[256];
	CGIForm *form = CGIReadForm();

	if(name && name[0] == '/')
		name++;

	if(!name || !*name)
	{
		printf("<META HTTP-EQUIV=\"Refresh\" CONTENT=\"0;URL=http://www.beyondterra.org/wiki/Main\">\n<a href=\"/wiki/Main\">Entry</a>\n");
		return;
	}

	strcpy(topic, name);

	if(!CheckName(topic))
		return;

	sprintf(path, "%s/%s", WIKI_PATH, topic);

#ifdef HISTORY
	if(CGIGetFormValue(form, "history"))
	{
		FILE *pipe;

		CGIFreeForm(form);
		/* handle history */
		PageStart(topic);
		ContentStart();

		printf("<h1>History</h1>\n<ul>\n");

		sprintf(path, "/usr/bin/rlog %s/%s", WIKI_PATH, topic);
		pipe = popen(path, "r");
		while(fgets(path, sizeof(path), pipe))
		{
			char *r, *p;
			Boolean current = false;
			if(strncmp(path, "revision", 8))
				continue;
			r = &path[9];
			p = strpbrk(r, " \t\n");
			if(p)
			{
				*(p++) = '\0';
				if(!strncmp(p, "locked by", 9))
					current = true;
			}
			printf("<li>$Revision: %s $ ", r);
			if(current)
				printf("(current)");
			if(!strcmp(r, "1.1"))
				printf("(initial revision)");
			printf("\n");

			/*printf("%s", path);*/
		}
		fclose(pipe);

		printf("</ul>\n");

		ContentEnd();

		printf("<div align=center>\n");
		printf("<a href=\"%s\">[ View ]</a>", topic);
		printf("</div>\n");

		PageEnd(topic);

		return;
	}
#endif

	CGIFreeForm(form);
	f = fopen(path, "r");
	if(f == NULL)
		return;

	WikiStart(topic);

	yyin = f;
	yylex();

	fclose(f);

	WikiEnd(topic);
}

char *GetRevision(char *topic)
{
	char path[256];
	FILE *f;
	char buf[256];
	static char revision[64];

	sprintf(path, "%s/RCS/%s,v", WIKI_PATH, topic);

	strcpy(revision, "new");
	f = fopen(path, "r");
	if(f)
	{
		while(fgets(buf, sizeof(buf), f))
		{
			if(!strncmp(buf, "head", 4))
			{
				char *p = buf;
				char *end;
				p += 4;
				while(*p && isspace(*p))
					*p++;
				end = strchr(p, ';');
				if(end)
					*end = '\0';
				strcpy(revision, p);
				break;
			}
		}
		fclose(f);
	}
	return(revision);
}

