#include <stdio.h>
#include <string.h>
#include "main.h"
#include "site.h"

void ContentStart()
{
	printf("<table width=\"100%%\">\n<tr>\n<td class=\"content\">\n");
}

void PageStart(char *title)
{
	printf("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n");
	printf("<html>\n");
	printf("<head>\n");
	printf("<title>%s : %s</title>\n", SITE_NAME, title);
	printf(SITE_HEADERS);
	printf("</head>\n");
	printf("<body>\n");
	printf(SITE_HEADER);
}

void WikiStart(char *title)
{
	PageStart(title);
	ContentStart();
	printf("<h1>%s</h1>\n", title);
}

void ContentEnd()
{
	printf("</td>\n</tr>\n</table>\n");
}

void PageEnd(char *topic, char *trailer)
{
	printf(SITE_FOOTER);
	if(trailer)
		printf(trailer);
	printf("</p>\n");
	printf("</body>\n");
	printf("</html>\n");
}

void WikiEnd(char *topic)
{
	char rev[128];

	ContentEnd();
	printf("<div align=center>\n");
	printf("<a href=\"%s/%s&revision=%s\">[ Edit ]</a>", WikiEditPath(), topic, GetRevision(topic));
	printf(" <a href=\"../history/%s\">[ History ]</a>", topic);
	printf(" <a href=\"/user\">[ Access ]</a>");
	printf("</div>\n");

	printf("<br>\n<form action=\"%s\" method=POST>\n"\
"<table>\n<tr>\n"\
"<td><input type=text name=search size=32 maxlength=255></td>\n"\
"<td><input type=submit value=Search></td>\n"\
"</tr>\n</table>\n"\
"</form>\n",
		WikiSearchPath());

	sprintf(rev, "<br>$Revision: %s $\n", GetRevision(topic));

	PageEnd(topic, rev);
}

