#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include "main.h"
#include "cgi.h"
#include "wiki.h"
#include "site.h"

void DumpEnv(char **envp)
{
	int i = 0;
	while(envp[i])
	{
		printf("%s<br>\n", envp[i]);
		i++;
	}
}

void EditPage(char *topic, char *rev)
{
	FILE *f;
	char buf[256], path[256];

	sprintf(path, "%s/%s", WIKI_PATH, topic);

	if(IsWikiDefined(topic))
		printf("<h1>Modify %s</h1>\n", topic);
	else
		printf("<h1>Create %s</h1>\n", topic);

	printf("<form action=\"%s\" method=POST>\n", CGIReadScript());
	printf("<input type=hidden name=topic value=%s>\n", topic);
	printf("<input type=hidden name=revision value=%s>\n", rev);
	printf("<textarea name=data cols=80 rows=25>\n");
	if(IsWikiDefined(topic))
	{
		f = fopen(path, "r");
		if(f)
		{
			while(fgets(buf, sizeof(buf), f))
				printf(buf);
			fclose(f);
		}
	}
	printf("</textarea>\n<br>\n");

	printf("<input type=submit value=\"Save Changes\">\n");
	printf("</form>\n");

	printf(EDIT_WEASEL_WORDS);
}

int main(int argc, char **argv, char **envp)
{
	char *p;
	char topic[256], *data = NULL, rev[64];
	char buf[256];
	CGIForm *f;

	f = CGIReadForm();

	data = CGIGetFormValue(f, "data");

	p = CGIGetFormValue(f, "topic");
	if(p == NULL)
	{
		CGIHeader();
		CGIFreeForm(f);
		return(0);
	}
	if(p[0] == '/')
		p++;
	strcpy(topic, p);
	p = CGIGetFormValue(f, "revision");
	if(p)
		strcpy(rev, p);
	else
		strcpy(rev, "new");

	if(!CheckName(topic))
	{
		CGIHeader();
		CGIFreeForm(f);
		return(0);
	}

	if(data)
	{
		char path[256];
		FILE *fout;
		char *currentRev;

		sprintf(path, "%s/%s", WIKI_PATH, topic);

		currentRev = GetRevision(topic);
		if(strcmp(currentRev, rev))
		{
			CGIHeader();
			printf("<p>Someone else edited %s while you were making changes.</p>", topic);
			printf("<br><a href=\"wiki/%s\">Try Again</a>\n", topic);
			exit(0);
		}

		fout = fopen(path, "w");
		if(fout)
		{
			fwrite(data, sizeof(char), strlen(data), fout);
			fclose(fout);
		}

		sprintf(path, "/usr/bin/ci -q -l -mnone -t- -w%s %s/%s", CGIGetUser(), WIKI_PATH, topic);
		system(path);
	
		sprintf(path, "wiki/%s", topic);	
		CGIRedirect(path);
		CGIFreeForm(f);
		return(0);
	}

	CGIFreeForm(f);
	CGIHeader();
	PageStart(topic);
	ContentStart();

	EditPage(topic, rev);

	ContentEnd();

	sprintf(buf, "<br>$Revision: %s $", rev);
	PageEnd(topic, buf);

	return(0);
}

