#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <limits.h>
#include "main.h"
#include "cgi.h"

void CGIHeader()
{
	printf("Content-Type: text/html\r\n\r\n");
}

void CGIRedirect(char *path)
{
	printf("Content-Type: text/html\r\n");
	printf("Location: %s\r\n\r\n", path);
	printf("You should be automatically redirected to <a href=\"%s\">%s</a>\n", path, path);
}

CGIForm *CGIReadForm()
{
	static char buf[4096];
	char *p, *s, *form = NULL;
	CGIForm *f = NULL, *last;

	p = getenv("QUERY_STRING");
	if(p && *p)
		form = p;
	s = getenv("REQUEST_METHOD");
	if(s && !strcmp(s, "POST") && fgets(buf, sizeof(buf), stdin))
		form = buf;

	if(form == NULL)
		return(NULL);

	p = form;
	while(p)
	{
		char *value, *name, *u, *c;

		s = strchr(p, '&');
		if(s)
			*(s++) = '\0';

		name = p;
		value = strchr(name, '=');
		if(value)
			*(value++) = '\0';
		p = s;

		if(f == NULL)
		{
			f = (CGIForm*) malloc(sizeof(CGIForm));
			if(f == NULL)
				return(NULL);
			f->name = strdup(name);
			if(value)
				f->value = strdup(value);
			else
				f->value = NULL;
			f->next = NULL;
			last = f;
		} else {
			CGIForm *tmp;
			tmp = (CGIForm*) malloc(sizeof(CGIForm));
			if(tmp == NULL)
				return(f);
			tmp->name = strdup(name);
			if(value)
				tmp->value = strdup(value);
			else
				tmp->value = NULL;
			tmp->next = NULL;
			last->next = tmp;
			last = tmp;
		}


		c = u = last->value;
		while(c && *c)
		{
			if(*c == '%')
			{
				char digit[3];
				digit[0] = c[1];
				digit[1] = c[2];
				digit[2] = '\0';
				*u = (unsigned char) strtoul(digit, NULL, 16);
				if(*u != '\r')
					u++;
				c += 3;
				continue;
			}
			else if(*c == '+')
				*u = ' ';
			else
			{
				if(*c == '\r')
				{
					c++;
					continue;
				}
				*u = *c;
			}
			u++;
			c++;
		}
		if(u)
			*u = '\0';
	}

	return(f);
}

char *CGIGetFormValue(CGIForm *form, char *name)
{
	CGIForm *ptr = form;

	while(ptr)
	{
		if(!strcasecmp(name, ptr->name))
			return(ptr->value);
		ptr = ptr->next;
	}
	return(NULL);
}

void CGIFreeForm(CGIForm *form)
{
	CGIForm *ptr = form, *tmp;
	while(ptr)
	{
		tmp = ptr->next;
		if(ptr->name)
			free(ptr->name);
		if(ptr->value)
			free(ptr->value);
		free(ptr);
		ptr = tmp;
	}
}

char *CGIReadPath()
{
	return(getenv("PATH_INFO"));
}

char *CGIReadScript()
{
	return(getenv("SCRIPT_NAME"));
}

char *CGIGetUser()
{
	return(getenv("REMOTE_USER"));
}

Boolean CGIIsLocal()
{
	char *a, *b;
	a = getenv("REMOTE_ADDR");
	b = getenv("SERVER_ADDR");
	if(!a || !b)
		return(false);
	if(!strcmp(a, b))
		return(true);
	return(false);
}

