package WWW::StockPrice; 
require 5.002;
use strict;

use LWP::UserAgent;
use URI::URL;
use HTTP::Request;

require Exporter;
use vars       qw($VERSION @ISA @EXPORT @EXPORT_OK);

# set the version for version checking
$VERSION     = 1.0.7;

@ISA         = qw(Exporter);
@EXPORT      = qw(&GetStockPrice);

my $debug = 1;
my $agent = 'Mozilla/4.61 [en] (Win98; I)';

sub GetUrl {
	my ($geturl) = @_;
	my $ua = new LWP::UserAgent;
	my $request;

	my $url = new URI::URL($geturl);

	$request = new HTTP::Request('GET', $url);

	$request->header('User-Agent', $agent);

	my $response = $ua->request($request, undef, undef);

	if($response->is_success) {
		#my $str = $response->as_string;
		my $str = $response->content();
		return($str);
	} else {
		if($debug) {
			print $response->code . "\n";
			my $str = $response->as_string;
			print $str . "\n";
		}
		return("");
	}
}

# data as described in http://www.gummy-stuff.org/Yahoo-data.htm
sub GetStockPrice {
	my ($ssym) = @_;

	my $sym = uc($ssym);
	$sym = '^IXIC' if($ssym eq 'NASDAQ');
	$sym = '^DJI' if($ssym eq 'DOW');
	$sym = '^GSPC' if($ssym eq 'SP500');
	#$sym = 'DJI' if($ssym eq 'DOW');

	print "Checking $sym...\n" if($debug);
	my $geturl = "http://download.finance.yahoo.com/d/quotes.csv?s=$sym&f=nll1c1p2";
	print "URL = $geturl\n" if($debug);
	my $str = GetUrl($geturl);

	my $symbol = '';
	my $price = '';
	my $change = '';
	my $percent = '';
	my $tradeTime = '';

	# "CISCO SYS INC","1:17pm - <b>23.13</b>",23.13,-0.06,"-0.26%"
	$str =~ /"([^"]*)","([^"]*)",([^,]*),([^,]*),"([^"]*)"/;
	$symbol = $1;
	$tradeTime = $2;
	$price = $3;
	$change = $4;
	$percent = $5;
	$tradeTime =~ s/\s-.*$//;

	if($change eq "N/A") {
		return("No symbol $sym");
	}

	print "Results: $str\n" if($debug);

	if($debug) {
		print "Symbol: '$symbol'\n";
		print "Last Trade: '$tradeTime'\n";
		print "Price: '$price'\n"; 
		print "Change: '$change'\n";
		print "Change Percent: '$percent'\n";
	}

	$str = "$symbol: $price ($change, $percent)";
        return($str);                                                  
}                         

#END { }       # module clean-up code here (global destructor)

1;


if($#ARGV >= 0) {
	foreach my $sym (@ARGV) {
		my $price = GetStockPrice($sym);
		print "*** $price\n";
	}
} else {
	my $price = GetStockPrice('AAPL');
	print "*** $price\n";
}

