using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace RaidMonitor
{
	public partial class Form1 : Form
	{
		private int m_state = 0;

		public Form1()
		{
			InitializeComponent();
		}

		private void CheckStatus()
		{
			notifyIcon1.Text = "Checking...";
			notifyIcon1.Icon = Properties.Resources.undecided;

			if (String.IsNullOrEmpty(Properties.Settings.Default.Server))
			{
				notifyIcon1.ShowBalloonTip(5, "RAID Monitor", "Please click Configure... to set up a server.", ToolTipIcon.Info);
				m_state = 0;
				return;
			}

			bool happy = true;
			List<Controller> controllers = null;
			try
			{
				controllers = Controller.GetControllers(Properties.Settings.Default.Server, Properties.Settings.Default.Port);
				foreach (Controller c in controllers)
				{
					if (c.IsOK == false)
					{
						happy = false;
						break;
					}
				}
			}
			catch (Exception ex)
			{
				notifyIcon1.ShowBalloonTip(5, "Can't connect to " + Properties.Settings.Default.Server, ex.Message, ToolTipIcon.Error);
				return;
			}

			if (happy)
			{
				if (m_state != 1)
					notifyIcon1.ShowBalloonTip(5, "RAID Status OK", "The array is working properly.", ToolTipIcon.Info);
				m_state = 1;
				notifyIcon1.Icon = Properties.Resources.happy;
				notifyIcon1.Text = "OK";
			}
			else
			{
				string summary = "";
				foreach (Controller c in controllers)
				{
					if (c.IsOK == false)
					{
						foreach (Port p in c.Ports)
						{
							if (p.IsOK == false)
							{
								if(String.IsNullOrEmpty(summary) == false)
									summary += "\n";
								summary += "Port " + p.PortNumber + " on " + c.Name;
							}
						}
					}
				}
				if(m_state != 2)
					notifyIcon1.ShowBalloonTip(5, "RAID Degraded", summary, ToolTipIcon.Error);
				m_state = 2;
				notifyIcon1.Icon = Properties.Resources.sad;
				notifyIcon1.Text = "FAILED";
			}
		}

		private void checkNowToolStripMenuItem_Click(object sender, EventArgs e)
		{
			CheckStatus();
		}

		private void Form1_Load(object sender, EventArgs e)
		{
			CheckStatus();
			this.Visible = false;
		}

		private void exitToolStripMenuItem_Click(object sender, EventArgs e)
		{
			Application.Exit();
		}

		private void Form1_Shown(object sender, EventArgs e)
		{
			this.Visible = false;
		}

		private void button2_Click(object sender, EventArgs e)
		{
			this.Visible = false;
		}

		private void configureToolStripMenuItem_Click(object sender, EventArgs e)
		{
			this.Visible = true;
		}

		private void button1_Click(object sender, EventArgs e)
		{
			Properties.Settings.Default.Server = textBox1.Text;
			Properties.Settings.Default.Port = Convert.ToInt32(numericUpDown1.Value);
			Properties.Settings.Default.Save();
			this.Visible = false;
			m_state = 0;
			CheckStatus();
		}

		private void Form1_VisibleChanged(object sender, EventArgs e)
		{
			textBox1.Text = Properties.Settings.Default.Server;
			numericUpDown1.Value = Properties.Settings.Default.Port;
		}

		private void timer1_Tick(object sender, EventArgs e)
		{
			CheckStatus();
		}
	}
}