using System;
using System.Collections.Generic;
using System.Text;
using System.Net.Sockets;
using System.Text.RegularExpressions;
using System.IO;

namespace RaidMonitor
{
	public class Port
	{
		public int PortNumber;
		public string Name;
		public string DiskSize;
		public string Status;

		public Port()
		{
			PortNumber = 0;
			Name = "";
			DiskSize = "";
			Status = "";
		}

		public override string ToString()
		{
			return (Name);
		}

		public bool IsOK
		{
			get
			{
				return (Status == "OK");
			}
		}
	}

	public class Controller
	{
		public string Name;
		public string Volume;
		public string VolumeSize;
		public string Status;
		public List<Port> Ports;

		public Controller()
		{
			Name = "";
			Volume = "";
			VolumeSize = "";
			Status = "";
			Ports = new List<Port>();
		}

		public override string ToString()
		{
			return (Name);
		}

		public bool IsOK
		{
			get
			{
				return (Status == "OK");
			}
		}

		public static List<Controller> GetControllers(string server, int port)
		{
			List<Controller> result = new List<Controller>();

			TcpClient socket = new TcpClient(server, port);
			NetworkStream stream = socket.GetStream();
			StreamReader sr = new StreamReader(stream);
			byte[] request = Encoding.ASCII.GetBytes("GET /index.html HTTP/1.0\r\n\r\n");
			stream.Write(request, 0, request.Length);

			string data = sr.ReadToEnd();

			if (data.IndexOf("<i>3DM Version 1.") == -1)
				throw new ApplicationException("Unknown 3DM Version.");

			string content = "<!-- END NAVBAR 2 -->";
			string endContent = "<HR>";
			int idx = data.ToUpper().IndexOf(content);
			if (idx != -1)
				data = data.Substring(idx + content.Length);
			idx = data.ToUpper().IndexOf(endContent);
			if (idx != -1)
				data = data.Substring(0, idx);
			data = data.Replace("&nbsp;", " ");
			data = data.Replace("</ul><br></ul></font></font>", "");
			data = data.Replace("<br>", "");
			data = data.Replace("<ul>", "");
			data = data.Replace("<li>", "");
			data = data.Replace("<h3>", "<controller>");
			data = data.Replace("<h4>", "<volume>");
			data = Regex.Replace(data, @"</?font\s+color[^>]*>", "<status>");
			data = Regex.Replace(data, @"</?font[^>]*>", "");
			data = Regex.Replace(data, @"</h\d>", "");
			data = data.Trim();

			foreach(string x in data.Split('\n'))
			{
				string line = x.Trim();
				if (String.IsNullOrEmpty(line))
					continue;
				if (line.StartsWith("<controller>"))
				{
					Controller c = new Controller();
					line = line.Replace("<controller>", "");
					c.Name = line.Trim();
					result.Add(c);
				}
				else if (line.StartsWith("<volume>") && result.Count > 0)
				{
					line = line.Replace("<volume>", "");
					Match m = Regex.Match(line, "<status>(.*)$");
					if (m.Success)
					{
						result[result.Count - 1].Status = m.Groups[1].ToString();
						line = Regex.Replace(line, @"<status>.*$", "");
					}
					m = Regex.Match(line, @"(\d+\.\d+\s\w+)");
					if (m.Success)
					{
						result[result.Count - 1].VolumeSize = m.Groups[1].ToString();
						line = line.Replace(result[result.Count - 1].VolumeSize, "");
					}
					result[result.Count - 1].Volume = line.Trim();
				}
				else if (result.Count > 0)
				{
					Port p = new Port();
					Match m = Regex.Match(line, "<status>(.*)$");
					if (m.Success)
					{
						p.Status = m.Groups[1].ToString().Trim();
						line = Regex.Replace(line, @"<status>.*$", "");
					}
					m = Regex.Match(line, @"(\d+\.\d+\s\w+)");
					if (m.Success)
					{
						p.DiskSize = m.Groups[1].ToString();
						line = line.Replace(p.DiskSize, "");
					}
					m = Regex.Match(line, @"^Port\s(\d+)");
					if (m.Success)
					{
						p.PortNumber = Convert.ToInt32(m.Groups[1].ToString());
						line = line.Replace(m.Groups[0].ToString(), "");
					}
					p.Name = line.Trim();
					result[result.Count - 1].Ports.Add(p);
				}
			}

			return (result);
		}
	}
}
