using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Text;
using System.Diagnostics;
using System.Windows.Forms;

namespace JPEGSpinner
{
	public partial class Form1 : Form
	{
		private string directory = "";

		public Form1()
		{
			InitializeComponent();
		}

		private void Form1_Load(object sender, EventArgs e)
		{
			this.Text = System.Reflection.Assembly.GetExecutingAssembly().GetName().Name;
			comboBox1.SelectedIndex = 0;
			UpdateSelectionCount();
		}

		#region Load Directory's Images
		private void Form1_DragDrop(object sender, DragEventArgs e)
		{
			Cursor = Cursors.WaitCursor;
			string[] files = (string[])e.Data.GetData(DataFormats.FileDrop);
			if (files.Length == 1 && Directory.Exists(files[0]))
				ScanDir(files[0]);
			Cursor = Cursors.Default;
		}

		private void Form1_DragEnter(object sender, DragEventArgs e)
		{
			if (e.Data.GetDataPresent(DataFormats.FileDrop))
			{
				string[] files = (string[])e.Data.GetData(DataFormats.FileDrop);
				if(files.Length == 1 && Directory.Exists(files[0]))
					e.Effect = DragDropEffects.Copy;
				else
					e.Effect = DragDropEffects.None;
			}
			else
				e.Effect = DragDropEffects.None;
		}

		private void ScanDir(string path)
		{
			directory = path;

			// clear previous data
			for (int i = 0; i < dataGridView1.Rows.Count; i++)
			{
				Bitmap bm = (Bitmap)dataGridView1.Rows[i].Cells[1].Value;
				if (bm != null)
					bm.Dispose();
			}
			dataGridView1.Rows.Clear();

			foreach (string file in Directory.GetFiles(path))
				LoadImage(new FileInfo(file));
			//foreach (string dir in Directory.GetDirectories(path))
			//	ScanDir(dir);
			UpdateSelectionCount();
		}
		#endregion

		#region Load Data Grid
		private void LoadImage(FileInfo file)
		{
			// only load jpegs
			if (file.Extension.ToLower() != ".jpg")
				return;

			try
			{
				using (Bitmap bm = LoadThumbnail(file.FullName))
				{
					object[] row = { false, new Bitmap(bm), file.Name };
					dataGridView1.Rows.Add(row);
					bm.Dispose();
				}
			}
			catch (Exception ex)
			{
				MessageBox.Show(ex.Message);
			}
		}
		#endregion

		#region Item Selection
		private void UpdateSelectionCount()
		{
			int count = 0;
			for (int i = 0; i < dataGridView1.Rows.Count; i++)
			{
				if ((bool)dataGridView1.Rows[i].Cells[0].Value)
					count++;
			}
			label2.Text = count.ToString() + " images selected";

			bool enabled = true;
			if (count == 0)
				enabled = false;
			button2.Enabled = enabled;
			button3.Enabled = enabled;
			button5.Enabled = enabled;
			comboBox1.Enabled = enabled;
		}

		// toggle item
		private void dataGridView1_Click(object sender, EventArgs e)
		{
			if (dataGridView1.CurrentRow != null)
				dataGridView1.CurrentRow.Cells[0].Value = !((bool)dataGridView1.CurrentRow.Cells[0].Value);
			UpdateSelectionCount();
		}

		// toggle all items
		private void button3_Click(object sender, EventArgs e)
		{
			for(int i = 0; i < dataGridView1.Rows.Count; i++)
				dataGridView1.Rows[i].Cells[0].Value = !((bool)dataGridView1.Rows[i].Cells[0].Value);
			UpdateSelectionCount();
		}


		private void button5_Click(object sender, EventArgs e)
		{
			for (int i = 0; i < dataGridView1.Rows.Count; i++)
				dataGridView1.Rows[i].Cells[0].Value = false;
			UpdateSelectionCount();
		}

		private void button4_Click(object sender, EventArgs e)
		{
			for (int i = 0; i < dataGridView1.Rows.Count; i++)
				dataGridView1.Rows[i].Cells[0].Value = true;
			UpdateSelectionCount();
		}
		#endregion

		#region Image Manipulation
		private void button2_Click(object sender, EventArgs e)
		{
			this.Enabled = false;
			this.Cursor = Cursors.WaitCursor;
			for (int i = 0; i < dataGridView1.Rows.Count; i++)
			{
				if ((bool)dataGridView1.Rows[i].Cells[0].Value == false)
					continue;
				string filePath = dataGridView1.Rows[i].Cells[2].Value.ToString();
				string path = Path.Combine(directory, filePath);
				Process p = new Process();
				p.StartInfo.WorkingDirectory = Environment.CurrentDirectory;
				p.StartInfo.CreateNoWindow = true;
				p.StartInfo.UseShellExecute = true;
				p.StartInfo.WindowStyle = ProcessWindowStyle.Hidden;
				p.StartInfo.FileName = "jhead.exe";
				switch (comboBox1.Items[comboBox1.SelectedIndex].ToString())
				{
					case "AutoRotate":
						p.StartInfo.Arguments = "-autorot \"" + path + "\"";
						break;
					case "Rotate 90":
						p.StartInfo.Arguments = " -cmd \"jpegtran -rotate 90 -outfile &o &i\" \"" + path + "\"";
						break;
					case "Rotate 180":
						p.StartInfo.Arguments = " -cmd \"jpegtran -rotate 180 -outfile &o &i\" \"" + path + "\"";
						break;
					case "Rotate 270":
						p.StartInfo.Arguments = " -cmd \"jpegtran -rotate 270 -outfile &o &i\" \"" + path + "\"";
						break;
					case "Flip Horizontal":
						p.StartInfo.Arguments = " -cmd \"jpegtran -flip horizontal -outfile &o &i\" \"" + path + "\"";
						break;
					case "Flip Vertical":
						p.StartInfo.Arguments = " -cmd \"jpegtran -flip vertical -outfile &o &i\" \"" + path + "\"";
						break;
				}
				p.Start();
				p.WaitForExit();

				Bitmap rowBitmap = (Bitmap)dataGridView1.Rows[i].Cells[1].Value;
				if (rowBitmap != null)
					rowBitmap.Dispose();
				using (Bitmap bm = LoadThumbnail(path))
				{
					dataGridView1.Rows[i].Cells[1].Value = new Bitmap(bm);
					bm.Dispose();
				}
			}
			this.Enabled = true;
			this.Cursor = Cursors.Default;

		}

		private Bitmap LoadThumbnail(string path)
		{
			Bitmap result = null;
			using (Bitmap bm = new Bitmap(path))
			{
				double hFactor = Convert.ToDouble(120) / Convert.ToDouble(bm.Width);
				double vFactor = Convert.ToDouble(120) / Convert.ToDouble(bm.Height);
				double factor = hFactor;
				if (vFactor < hFactor)
					factor = vFactor;
				if (factor > 1.0)
					result = new Bitmap(bm);
				else
				{
					int w = Convert.ToInt32(factor * Convert.ToDouble(bm.Width));
					int h = Convert.ToInt32(factor * Convert.ToDouble(bm.Height));
					result = new Bitmap(bm, w, h);
				}

			}
			return (result);
		}
		#endregion
	}
}