using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Microsoft.Win32;

namespace HappyGPSLogger
{
	public partial class Settings : Form
	{
		private readonly static string m_appKey = @"Software\zenwheel\GPSLogger";

		public Settings()
		{
			InitializeComponent();
		}

		private static void SetRegistryValue(string key, string val)
		{
			using (RegistryKey rk = Registry.CurrentUser.CreateSubKey(m_appKey))
			{
				if (rk != null)
					rk.SetValue(key, val, RegistryValueKind.String);
			}
		}

		private static string GetRegistryValue(string key)
		{
			string result = String.Empty;
			using (RegistryKey rk = Registry.CurrentUser.OpenSubKey(m_appKey))
			{
				if (rk != null)
					result = rk.GetValue(key, String.Empty).ToString();
			}
			return (result);
		}

		public static string SerialPort
		{
			get { return (GetRegistryValue("Port")); }
			set { SetRegistryValue("Port", value); }
		}

		public static string BaudRate
		{
			get { return (GetRegistryValue("Baud")); }
			set { SetRegistryValue("Baud", value); }
		}

		private void menuItem2_Click(object sender, EventArgs e)
		{
			this.DialogResult = DialogResult.Cancel;
		}

		private void menuItem1_Click(object sender, EventArgs e)
		{
			SerialPort = comboBox1.Items[comboBox1.SelectedIndex].ToString();
			BaudRate = comboBox2.Items[comboBox2.SelectedIndex].ToString();
			this.DialogResult = DialogResult.OK;
		}

		private void Settings_Load(object sender, EventArgs e)
		{
			// which serial port
			int selectedPort = 0;
			string currentPort = SerialPort;
			string[] ports = System.IO.Ports.SerialPort.GetPortNames();
			comboBox1.Items.Clear();
			for(int i = 0; i < ports.Length; i++)
			{
				string p = ports[i];
				comboBox1.Items.Add(p);
				if(p == currentPort)
					selectedPort = i;
			}
			comboBox1.SelectedIndex = selectedPort;

			// baud rate
			if (BaudRate == "38400")
				comboBox2.SelectedIndex = 1;
			else
				comboBox2.SelectedIndex = 0;
		}
	}
}