using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices;

namespace HappyGPSLogger
{
	public class Bluetooth
	{
		[DllImport("BthUtil.dll")]
		private static extern int BthGetMode(out BluetoothRadioMode dwMode);
		[DllImport("BthUtil.dll")]
		private static extern int BthSetMode(BluetoothRadioMode dwMode);

		public enum BluetoothRadioMode
		{
			Off,
			On,
			Discoverable
		}

		public static BluetoothRadioMode Mode
		{
			get
			{
				BluetoothRadioMode result;
				BthGetMode(out result);
				return (result);
			}

			set
			{
				if (value != Mode)
					BthSetMode(value);
			}
		}
	}
}
