using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Runtime.InteropServices;
using System.Windows.Forms;
using System.Data;
using System.IO;
using System.Text.RegularExpressions;

namespace GoogleImager
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class Form1 : System.Windows.Forms.Form
	{
		private string m_folder = null;
		private System.Windows.Forms.FolderBrowserDialog folderBrowserDialog1;
		private System.Windows.Forms.ListBox Albums;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.Label ArtistLbl;
		private System.Windows.Forms.Label AlbumLbl;
		private System.Windows.Forms.Label DirLbl;
		private AxSHDocVw.AxWebBrowser axWebBrowser1;
		private System.Windows.Forms.Label ErrorLbl;
		private System.Windows.Forms.PictureBox pictureBox1;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public Form1()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(Form1));
			this.Albums = new System.Windows.Forms.ListBox();
			this.folderBrowserDialog1 = new System.Windows.Forms.FolderBrowserDialog();
			this.label1 = new System.Windows.Forms.Label();
			this.label2 = new System.Windows.Forms.Label();
			this.label3 = new System.Windows.Forms.Label();
			this.ArtistLbl = new System.Windows.Forms.Label();
			this.AlbumLbl = new System.Windows.Forms.Label();
			this.DirLbl = new System.Windows.Forms.Label();
			this.axWebBrowser1 = new AxSHDocVw.AxWebBrowser();
			this.ErrorLbl = new System.Windows.Forms.Label();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			((System.ComponentModel.ISupportInitialize)(this.axWebBrowser1)).BeginInit();
			this.SuspendLayout();
			// 
			// Albums
			// 
			this.Albums.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.Albums.Location = new System.Drawing.Point(8, 8);
			this.Albums.Name = "Albums";
			this.Albums.Size = new System.Drawing.Size(344, 381);
			this.Albums.TabIndex = 0;
			this.Albums.SelectedIndexChanged += new System.EventHandler(this.Albums_SelectedIndexChanged);
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(440, 8);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(48, 16);
			this.label1.TabIndex = 1;
			this.label1.Text = "Artist:";
			this.label1.TextAlign = System.Drawing.ContentAlignment.TopRight;
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(432, 32);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(56, 16);
			this.label2.TabIndex = 2;
			this.label2.Text = "Album:";
			this.label2.TextAlign = System.Drawing.ContentAlignment.TopRight;
			// 
			// label3
			// 
			this.label3.Location = new System.Drawing.Point(432, 56);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(56, 16);
			this.label3.TabIndex = 3;
			this.label3.Text = "Directory:";
			this.label3.TextAlign = System.Drawing.ContentAlignment.TopRight;
			// 
			// ArtistLbl
			// 
			this.ArtistLbl.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.ArtistLbl.Location = new System.Drawing.Point(504, 8);
			this.ArtistLbl.Name = "ArtistLbl";
			this.ArtistLbl.Size = new System.Drawing.Size(280, 16);
			this.ArtistLbl.TabIndex = 5;
			// 
			// AlbumLbl
			// 
			this.AlbumLbl.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.AlbumLbl.Location = new System.Drawing.Point(504, 32);
			this.AlbumLbl.Name = "AlbumLbl";
			this.AlbumLbl.Size = new System.Drawing.Size(280, 16);
			this.AlbumLbl.TabIndex = 6;
			// 
			// DirLbl
			// 
			this.DirLbl.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.DirLbl.Location = new System.Drawing.Point(504, 56);
			this.DirLbl.Name = "DirLbl";
			this.DirLbl.Size = new System.Drawing.Size(280, 16);
			this.DirLbl.TabIndex = 7;
			// 
			// axWebBrowser1
			// 
			this.axWebBrowser1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.axWebBrowser1.Enabled = true;
			this.axWebBrowser1.Location = new System.Drawing.Point(360, 104);
			this.axWebBrowser1.OcxState = ((System.Windows.Forms.AxHost.State)(resources.GetObject("axWebBrowser1.OcxState")));
			this.axWebBrowser1.Size = new System.Drawing.Size(384, 416);
			this.axWebBrowser1.TabIndex = 9;
			this.axWebBrowser1.BeforeNavigate2 += new AxSHDocVw.DWebBrowserEvents2_BeforeNavigate2EventHandler(this.axWebBrowser1_BeforeNavigate2);
			// 
			// ErrorLbl
			// 
			this.ErrorLbl.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.ErrorLbl.ForeColor = System.Drawing.Color.Red;
			this.ErrorLbl.Location = new System.Drawing.Point(504, 80);
			this.ErrorLbl.Name = "ErrorLbl";
			this.ErrorLbl.Size = new System.Drawing.Size(280, 16);
			this.ErrorLbl.TabIndex = 10;
			// 
			// pictureBox1
			// 
			this.pictureBox1.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.pictureBox1.Location = new System.Drawing.Point(360, 8);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(80, 80);
			this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
			this.pictureBox1.TabIndex = 11;
			this.pictureBox1.TabStop = false;
			this.pictureBox1.Click += new System.EventHandler(this.pictureBox1_Click);
			// 
			// Form1
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(792, 397);
			this.Controls.Add(this.pictureBox1);
			this.Controls.Add(this.ErrorLbl);
			this.Controls.Add(this.axWebBrowser1);
			this.Controls.Add(this.DirLbl);
			this.Controls.Add(this.AlbumLbl);
			this.Controls.Add(this.ArtistLbl);
			this.Controls.Add(this.label3);
			this.Controls.Add(this.label2);
			this.Controls.Add(this.label1);
			this.Controls.Add(this.Albums);
			this.Name = "Form1";
			this.Text = "Google Imager";
			this.Load += new System.EventHandler(this.Form1_Load);
			((System.ComponentModel.ISupportInitialize)(this.axWebBrowser1)).EndInit();
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}

		private void Form1_Load(object sender, System.EventArgs e)
		{
			Albums.Items.Clear();
			if(System.Configuration.ConfigurationSettings.AppSettings.GetValues("Path") != null)
				m_folder = System.Configuration.ConfigurationSettings.AppSettings.GetValues("Path")[0];
			else if(folderBrowserDialog1.ShowDialog() == DialogResult.OK)
				m_folder = folderBrowserDialog1.SelectedPath;
			else
				Application.Exit();

			if(m_folder != null)
			{
				string[] artists = Directory.GetDirectories(m_folder);
				foreach(string artist in artists)
				{
					DirectoryInfo artistInfo = new DirectoryInfo(artist);
					string[] albums = Directory.GetDirectories(artist);
					foreach(string album in albums)
					{
						/*string[] songs = Directory.GetFiles(album, "*.mp3");
						if(songs.Length == 0)
							continue;
						if(File.Exists(album + "\\folder.jpg"))
							continue;*/
						DirectoryInfo albumInfo = new DirectoryInfo(album);
						Albums.Items.Add(artistInfo.Name + "/" + albumInfo.Name);
					}
				}
			}

			axWebBrowser1.Width = this.Width - axWebBrowser1.Left - 16;
			axWebBrowser1.Height = this.Height - axWebBrowser1.Top - 32;
		}

		private void Albums_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if(Albums.SelectedIndex == -1)
				return;
			string album = Albums.Items[Albums.SelectedIndex].ToString();
			string folder = m_folder + "\\" + album.Replace("/", "\\");
			string[] tmp = album.Split('/');

			string artist = tmp[0];
			album = tmp[1];

			// strip off year in album name
			Match m = Regex.Match(album, "^\\d{4}\\s*-\\s*(.*)$");
			if(m.Success)
				album = m.Groups[1].Captures[0].Value;

			ArtistLbl.Text = artist;
			AlbumLbl.Text = album;
			DirLbl.Text = folder;

			// http://images.google.com/images?q="artist" "album"
			string query = "http://images.google.com/images?q=%22" + System.Web.HttpUtility.UrlEncode(artist) + "%22%20%22" + System.Web.HttpUtility.UrlEncode(album) + "%22";

			object o = null;
			axWebBrowser1.Navigate(query, ref o, ref o, ref o, ref o);

			// draw any folder.jpg that exists
			if(pictureBox1.Image != null)
			{
				pictureBox1.Image.Dispose();
				pictureBox1.Image = null;
			}
			string filePath = folder + "\\folder.jpg";
			if(File.Exists(filePath))
			{
				Bitmap fileImage = new Bitmap(filePath);
				pictureBox1.Image = new Bitmap(fileImage);
				fileImage.Dispose();
			}
		}

		private void axWebBrowser1_BeforeNavigate2(object sender, AxSHDocVw.DWebBrowserEvents2_BeforeNavigate2Event e)
		{
			ErrorLbl.Text = "";
			string url = e.uRL.ToString();
			if(url.StartsWith("http://images.google.com/imgres?imgurl="))
			{
				e.cancel = true;
				//http://images.google.com/imgres?imgurl=http://www.fabrikainternational.com/gabriela-6%2520copy.jpg&imgrefurl=http://www.fabrikainternational.com/newnews.htm&h=140&w=140&sz=9&tbnid=BipdkWOL9oQJ:&tbnh=88&tbnw=88&hl=en&start=15&prev=/images%3Fq%3D%2522Gabriela%2BAnders%2522%2B%2522Last%2BTango%2Bin%2BRio%2522%26svnum%3D10%26hl%3Den%26lr%3D
				//http://images.google.com/imgres?imgurl=http://www.blackmailmag.com/images/MUSICA/Misery-is-a-butterfly.jpg&imgrefurl=http://www.blackmailmag.com/blonde_redhead.htm&h=299&w=300&sz=32&tbnid=06rQAo0lrOAJ:&tbnh=110&tbnw=111&hl=en&start=1&prev=/images%3Fq%3D%2522Blonde%2BRedhead%2522%2B%2522Misery%2BIs%2BA%2BButterfly%2522%26svnum%3D10%26hl%3Den%26lr%3D
				Match m = Regex.Match(url, "imgres\\?imgurl=([^&]*)");
				if(m.Success)
				{
					try
					{
						string imageUrl = m.Groups[1].Captures[0].Value;
						imageUrl = System.Web.HttpUtility.UrlDecode(imageUrl);
						string album = Albums.Items[Albums.SelectedIndex].ToString();
						string folder = m_folder + "\\" + album.Replace("/", "\\");
						string filePath = folder + "\\folder.jpg";

						File.Delete(filePath);
						System.Net.WebClient client = new System.Net.WebClient();
						client.DownloadFile(imageUrl, filePath);
						if(Albums.SelectedIndex + 1 < Albums.Items.Count)
							Albums.SelectedIndex++;
					}
					catch(Exception ex)
					{
						ErrorLbl.Text = "Error downloading new image: " + ex.Message;
					}
				}
			}
		}

		private void pictureBox1_Click(object sender, System.EventArgs e)
		{
			if(Albums.SelectedIndex + 1 < Albums.Items.Count)
				Albums.SelectedIndex++;
		}
	}
}
